local WriteInfoLogs = false -- Set to true to enable info logging

local function log_info(info_message)
  if WriteInfoLogs then
    log.info("[Chaplain Grimaldus > MEGA Buster ]: " .. info_message)
  end
end

local currentScene = nil
local hasRunInitially = false
local delayCounter = 0
local delayThreshold = 60 -- Adjust the number of frames to wait before retrying (similar to Dodge Timer script)

-- Frame update function with delay mechanism
re.on_frame(function()
  local sceneManager = sdk.get_native_singleton("via.SceneManager")
  if not sceneManager then
    log_info("SceneManager not found")
    return
  end

  local scene = sdk.call_native_func(sceneManager, sdk.find_type_definition("via.SceneManager"), "get_CurrentScene")
  if not scene then
    log_info("Current scene not found")
    return
  end

  -- If the scene has changed, reset the logic and delay
  if currentScene ~= scene then
    hasRunInitially = false
    currentScene = scene
    delayCounter = 0 -- Reset the delay counter on scene change
    log_info("Scene has changed, resetting invincibility")
  end

  -- Delay logic: only proceed when delayCounter reaches the threshold
  if not hasRunInitially and delayCounter >= delayThreshold then
    local megaBuster = scene:call("findGameObject(System.String)", "PREF_Item00a6_58")
    if megaBuster then
      log_info("Found Mega Buster in Scene")
    else
      log_info("Mega Buster not found, retrying...")
      return
    end

    local MBGun = megaBuster:call("getComponent(System.Type)",
      sdk.typeof("app.solid.implement.Gun"))
    if MBGun then
      log_info("Found Gun Component of MB")
    else
      log_info("Gun Component not found")
      return
    end

    -- Additional Gun component changes
    MBGun:set_field("<FireInterval>k__BackingField", 0.01)
    MBGun:set_field("<RapidFire>k__BackingField", true)

    -- Accessing the ShellGenerator and modifying ballistic settings
    local shellGenerator = MBGun:get_field("<ShellGenerator>k__BackingField")
    if shellGenerator then
      local tGeneratorUserDataBase = shellGenerator:get_field("_TGeneratorUserDataBase")
      if tGeneratorUserDataBase then
        local bulletGenerateSetting = tGeneratorUserDataBase:get_field("BulletGenerateSetting")
        if bulletGenerateSetting then
          local shellPrefabSetting = bulletGenerateSetting:get_field("ShellPrefabSetting")
          if shellPrefabSetting then
            local shellUserData = shellPrefabSetting:get_field("ShellUserData")
            if shellUserData then
              local ballisticSetting = shellUserData:get_field("BallisticSetting")
              if ballisticSetting then
                ballisticSetting:set_field("_FiringRange", 300)
                ballisticSetting:set_field("_EffectiveRange", 300)
                ballisticSetting:set_field("_Speed", 100)
                log_info("Ballistic settings updated successfully")
              else
                log_info("BallisticSetting not found")
              end
            else
              log_info("ShellUserData not found")
            end
          else
            log_info("ShellPrefabSetting not found")
          end
        else
          log_info("BulletGenerateSetting not found")
        end
      else
        log_info("_TGeneratorUserDataBase not found")
      end
    else
      log_info("ShellGenerator not found")
    end

    -- GunChargeDataList modifications
    local gunChargeDataList = MBGun:get_field("GunChargeDataList")
    if gunChargeDataList then
      local count = gunChargeDataList:call("get_Count")
      for i = 0, count - 1 do
        local chargeData = gunChargeDataList[i] -- Get each ChargeData
        if chargeData then
          local settings = chargeData:get_field("Setting")
          if settings then
            settings:set_field("ChargeTimeRequest", 0.01)
            log_info("ChargeTimeRequest set to 0.01 for index " .. i)
          else
            log_info("Settings not found for index " .. i)
          end
        else
          log_info("ChargeData not found for index " .. i)
        end
      end
    else
      log_info("GunChargeDataList not found")
    end

    hasRunInitially = true -- Ensure this logic runs only once per scene
  end

  -- Increment the delay counter each frame until the threshold is reached
  if not hasRunInitially then
    delayCounter = delayCounter + 1
  end
end)
